%% fisicaru.cls
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{fisicaru}[2025/10/04 Clase oficial para la revista FISICA.RU]

\LoadClass[11pt]{article}

% Paquetes necesarios
\RequirePackage[a4paper, margin=2.5cm]{geometry}
\RequirePackage{fancyhdr}
\RequirePackage{titlesec}
\RequirePackage{graphicx}
\RequirePackage{multicol}
\RequirePackage{amsmath, amssymb}
\RequirePackage{times}
\RequirePackage[utf8]{inputenc}
\RequirePackage[english, spanish]{babel}
\RequirePackage{caption}
%\RequirePackage{biblatex}
\captionsetup{labelfont=bf,font=small,labelsep=period}

% Encabezados
\pagestyle{fancy}
\fancyhf{}
\rhead{\thepage}
\lhead{FISICA.RU, Vol. X (2025)}

% Estilo de secciones
\titleformat{\section}{\bfseries\large}{\thesection.}{0.5em}{}
\titleformat{\subsection}{\bfseries}{\thesubsection}{0.5em}{}

% Separación entre columnas
\setlength{\columnsep}{0.7cm}
